#! /usr/local/bin/R
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
library(crayon)
library(devtools)

suppressMessages(suppressWarnings(library(bit64,verbose=F,warn.conflicts = F,quietly = T)));
library(lfe,warn.conflicts = F,quietly = T);
library(zeallot)
library(stargazer,warn.conflicts = F,quietly = T);
library(texreg,warn.conflicts = F,quietly = T);
library(brew)
library(purrr)
library(magrittr,warn.conflicts = F,quietly = T);
library(stringr,warn.conflicts = F,quietly = T);
library(glue,warn.conflicts = F,quietly = T)
library(haven,warn.conflicts = F,quietly = T)
library(RStata)
library(data.table,warn.conflicts = F,quietly = T);
library(statar,warn.conflicts = F,quietly = T)

library(did);
library(ggpubr)

sessionInfo()
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
star_maker <- function(x){
  ifelse(x>0.1, "", ifelse(x>0.05, "^{*}", ifelse(x>0.01, "^{**}", "^{***}") ) )
}
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# Read input datasets
dt_LR  <- read_dta("../task_LR/output/LRbetas_daily_trade.dta") %>% data.table
# ------------------------------------------------------------------------------------------

# ------------------------------------------------------------------------------------------
dt_LR[, id := factor(ISOPAIR) ]
dt_LR[, iso_1_t := interaction(base,year) ]
dt_LR[, iso_2_t := interaction(foreign,year) ]
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
dt_LR[,log_trade   := log(trade_gross) ]
dt_LR[,log_export  := log(export) ]
dt_LR[,log_import  := log(import) ]
dt_LR[,trade_share := (  trade_gross / gdp_o )*100 ]
dt_LR[,key_partner := 0 ]
dt_LR[trade_share > 1, key_partner := 1 ]
dt_LR[, fx_vol     := fx_vol*sqrt(252) ]

dt_LR[, l1y_EIA := tlag(EIA,time=year),by = .(ISOPAIR) ]
dt_LR[ year > 2012, EIA := l1y_EIA ]

dt_LR[, CUMECU := 0 ]
dt_LR[EIA == 4 | EIA == 5 | EIA == 6, CUMECU := 1 ]
dt_LR[,FTA := 0 ]
dt_LR[EIA == 3,FTA := 1 ]
dt_LR[,TWPTA := 0 ]
dt_LR[EIA == 2,TWPTA := 1 ]
dt_LR[,OWPTA := 0 ]
dt_LR[EIA == 1,OWPTA := 1 ]
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
dt_LR[,experiment := FTA + CUMECU ]
dt_LR[,l1y_experiment := tlag(experiment,time=year),by = .(ISOPAIR) ]
dt_LR[,treat := max(experiment,na.rm=T),by = .(ISOPAIR) ]
dt_LR[ !is.finite(treat),treat := 0 ]

dt_LR[,change := 0 ]
dt_LR[experiment > l1y_experiment,change := 1]
dt_LR[, change_id := max(change,na.rm=T) ]
dt_LR[ !is.finite(change_id), change_id := 0 ]

dt_LR[change==1, tmp_year := year ]
dt_LR[, event_year := na.omit(tmp_year)[1], by = .(ISOPAIR) ]
dt_LR[is.na(event_year), event_year := 0 ]
dt_LR[, tmp_year := NULL ]
dt_LR[, diff := year - event_year ]
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
dt_reg_tmp <- dt_LR[,.(ISOPAIR, ISO1=ISOEX, ISO2=ISOIM,iso_1_t,iso_2_t,year,event_year,
	distw, contig,comlang_off,comcol,comleg_pretrans,
	log_trade, R2_y, beta, fx_vol, var_adj, unshared_cls1, unshared_cls2) ]

# gen unique numbers for iso
dt_names = rbind(dt_reg_tmp[,.(iso=ISO1)], dt_reg_tmp[,.(iso=ISO2)]) %>% unique
dt_names <- dt_names[ iso != "" ][,.(iso, id_iso=1:.N)]
dt_reg_tmp <- merge(dt_reg_tmp, dt_names[,.(ISO1=iso,id_iso1=id_iso)], by = c("ISO1"))
dt_reg_tmp <- merge(dt_reg_tmp, dt_names[,.(ISO2=iso,id_iso2=id_iso)], by = c("ISO2"))
dt_reg_tmp[,id_isopair := 100*id_iso1 + id_iso2 ]
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# WINSORIZE THE DATA
dt_reg_tmp[, win_log_trade     := winsorize(log_trade) ]
dt_reg_tmp[, win_R2_y          := winsorize(R2_y) ]
dt_reg_tmp[, win_beta          := winsorize(beta) ]
dt_reg_tmp[, win_fx_vol        := winsorize(fx_vol) ]
dt_reg_tmp[, win_var_adj       := winsorize(var_adj) ]
dt_reg_tmp[, win_unshared_cls1 := winsorize(unshared_cls1) ]
dt_reg_tmp[, win_unshared_cls2 := winsorize(unshared_cls2) ]

dt_reg_tmp[, win2_log_trade     := winsorize(log_trade, replace=NA) ]
dt_reg_tmp[, win2_R2_y          := winsorize(R2_y, replace=NA) ]
dt_reg_tmp[, win2_beta          := winsorize(beta, replace=NA) ]
dt_reg_tmp[, win2_fx_vol        := winsorize(fx_vol, replace=NA) ]
dt_reg_tmp[, win2_var_adj       := winsorize(var_adj, replace=NA) ]
dt_reg_tmp[, win2_unshared_cls1 := winsorize(unshared_cls1, replace=NA) ]
dt_reg_tmp[, win2_unshared_cls2 := winsorize(unshared_cls2, replace=NA) ]
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
dt_dyn_full <- data.table()
l_var_sc_method <- paste0("win2_", 
                          c("log_trade", "R2_y", "beta", "fx_vol", "var_adj", "unshared_cls1", "unshared_cls2"))
setnames(dt_reg_tmp, "year", "date_y")
# dt_reg_tmp

for (var in l_var_sc_method){
  message(" Running ... ", var)

  out <- att_gt(
    yname = var,
    gname = "event_year", 
    idname = "id_isopair", 
    tname = "date_y",
    xformla = ~ISO1+ISO2,
    data = dt_reg_tmp,
    est_method = "ipw", # "reg", "ipw"
    print_details = TRUE,
    allow_unbalanced_panel = TRUE,
    control_group=c("notyettreated", "nevertreated"),
    # control.group=c("notyettreated"),
  )
  
  es <- aggte(out, type="dynamic", na.rm=T)

  dt_dyn <- data.table(time=es$egt, att=es$att.egt,
                       se=es$se.egt, crit_val=es$crit.val.egt)

  # uncomment to view results as figure  
  # ptmp = dt_dyn[ abs(time) <= 10 ] %>% ggplot() +
  #   geom_point(aes(x=time, y=att)) + 
  #   geom_errorbar(aes(x=time, ymin=att-2.0*se, ymax=att+2.0*se), 
  #                 colour="black", alpha=0.5, width=0.15) +
  #   geom_vline(xintercept=0, color="red", linetype="dashed") + 
  #   geom_hline(yintercept=0, color="black", linetype="solid") + theme_bw()
  # ggsave(glue("./output/figures/DiD_call_{var}.pdf"), ptmp, width=8, height=6, units="in")
  
  dt_dyn_full <- rbind(dt_dyn_full, dt_dyn[, var := var])
  
}

dt_dyn_full[, pval := pnorm(abs(att/se), lower.tail=FALSE) ]  # normal
#dt_dyn_full[, pval := 2*pt(-abs(att/se),df=nobs-1) ]          # t-stat

dt_dyn_full[]
dt_dyn_full %>% tab(var)
dt_dyn_full[, var := gsub("win2_", "", var)  ]
dt_dyn_full[, var := gsub("win_", "", var)  ]

brew("./input/tables/table_event_SC_reg.brew.tex", "./output/tables/tableA4.tex")
# ------------------------------------------------------------------------------------------





# 